var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0\">\n      <meta name=\"indexterm\" content=\"wrap deformer: use with nCloth\">\n      <meta name=\"indexterm\" content=\"nCloth: using with a wrap deformer\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Lesson 3: Wrapping the high resolution mesh and simulating the pants during animation</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0\"></a><div class=\"head\">\n            <h1>Lesson 3: Wrapping the high resolution mesh and simulating the pants during animation</h1>\n         </div>\n         <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A4D\"></a> In this lesson you will: \n            	 \n         </p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A4C\"></a><ul>\n            <li>Create a wrap deformer to influence the behavior of the high resolution mesh (Pants_HighRes).\n               \n               		\n            </li>\n            <li>Import geometry caches to animate the body (nRigid_Body) and shoe (nRigid_Shoes) meshes.\n               \n               		\n            </li>\n            <li>Create an nCache for the simulated nCloth pants object. \n               		\n            </li>\n            <li>Identify problem areas in the simulation, such as poorly deformed polygons and interpenetrations\n               caused by inaccurate collision detection between the nCloth and passive collision\n               objects or self collisions within the nCloth itself. \n               		\n            </li>\n            <li>Edit Nucleus solver \n               		  <span class=\"MenuCascade\" id=\"GUID-D879709A-35AE-4A72-A7F3-990A01CBFCEC\">Substeps</span> to improve the overall quality of the simulation. \n               		\n            </li>\n            <li>Set keyframes to increase \n               		  <span class=\"MenuCascade\" id=\"GUID-29EC1570-C0CF-4069-8887-E854F6F55D5B\">Substeps</span> at specific problem frames in the simulation. \n               		\n            </li>\n            <li>Resolve interpenetrations. \n               		\n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A42\"></a> \n            <h2><a name=\"GUID-8A379278-0B27-4CFE-90D5-4291AF0ACE8B\"></a>Lesson setup\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A41\"></a>To ensure the lesson works as described, do these steps before beginning: \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A40\"></a><ol type=\"1\" start=\"1\">\n               <li>If you have not already done so, download the nCloth Advanced Techniques Lesson Data\n                  from the following location: \n                  			 <a href=\"http://www.autodesk.com/maya-advancedtechniques\" target=\"_blank\">http://www.autodesk.com/maya-advancedtechniques</a>. Then, set the \n                  			 <span class=\"code\">nClothAdvancedTutorials</span> directory as your Maya project. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3E\"></a>For this lesson, you need to access Maya geometry cache files in addition to the lesson\n                     scene file. \n                     			 \n                  </p> \n               </li>\n               <li>Open the scene file named \n                  			 <span class=\"code\">Character_LowRes_3.mb</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3C\"></a>This file can be found in the \n                     				<span class=\"code\">nClothAdvancedTutorials</span> directory that you set as your Maya project. \n                     			 \n                  </p> \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3B\"></a> \n            <h2><a name=\"GUID-D04C5E0B-FA19-41BD-AA71-597D83778190\"></a>Wrapping the high resolution mesh\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A3A\"></a>In this lesson, you use a wrap deformer to create an influence object that causes\n               the high resolution mesh to behave like the simulated low resolution mesh. For more\n               information about the wrap deformer, see \n               		  <em class=\"mild\">Wrap Deformers</em> in the Maya Help. \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A39\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A38\"></a>To wrap the high resolution mesh\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-D7C95440-412E-4622-9D7C-E54DC64D7441\">Outliner</span>, expand \n                  			 <em class=\"mild\">Character_HighRes</em>, and show the \n                  			 <em class=\"mild\">Pants_HighRes</em> object by selecting it, and then selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-96A4F083-DB3D-4911-94FC-D9FA35BCAB12\">Display &gt; Show &gt; Show Selection</span>. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E38\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-871934FF-2051-4179-8F03-62B9365F9EF3-low.png\"></div> \n               </li>\n               <li> Ctrl-select the nCloth pants (Character_LowRes&gt;Pants_LowRes). \n                  		  \n               </li>\n               <li>From the \n                  			 <span class=\"MenuCascade\">Animation</span> menu set, select \n                  			 <span class=\"MenuCascade\">Anim Deform &gt; Open Full Deform Menu</span>. \n                  		  \n               </li>\n               <li>From the \n                  			 <span class=\"MenuCascade\">Deform</span> menu that appears, select \n                  			 <span class=\"MenuCascade\">Wrap</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A34\"></a>A wrap node appears in the \n                     				<span class=\"MenuCascade\" id=\"GUID-69F48498-09AA-49DC-B482-A1217D7F9127\">Attribute Editor</span>, and in the \n                     				<span class=\"MenuCascade\" id=\"GUID-E3F812CA-DFF1-42AB-8197-86921BFBC5A6\">Outliner</span>, you can see that the \n                     				<em class=\"mild\">Pants_LowResBase</em> object has been added to the \n                     				<em class=\"mild\">Character_LowRes \n                        				</em>group. \n                     			 \n                  </p> \n                  <div><a name=\"WS73099CC142F487557230B50811D7D192C64-74AA\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> \n                        <p><a name=\"GUID-204D14C9-D02B-4BD2-8F05-FB29536A5EA0\"></a>You may need to expand \n                           				  <em class=\"mild\">Character_LowRes</em> to see the<em class=\"mild\"> Pant_LowResBase</em> object in the<span class=\"MenuCascade\" id=\"GUID-77FEFCEA-9D57-4163-BF88-1A24CF87A563\"> Outliner</span>. \n                           				\n                        </p> \n                     </div>\n                  </div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E37\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-60E27646-D24E-4ECE-AF3E-BBEF1EF95FF9-low.png\"></div> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-EA461F5A-0794-40F0-9B17-65ED482DFF0A\">Attribute Editor</span>, click the \n                  			 <span class=\"MenuCascade\" id=\"GUID-96A8EFD2-882B-4A51-94B4-B9B850672957\">wrap1</span> tab. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-D3EB34B1-AFF6-4682-86D3-71059105AD8C\">Wrap Attributes</span> section, turn on<span class=\"MenuCascade\" id=\"GUID-7B3ACC42-3206-4C95-AED9-EDB4B07C1DD5\"> Exclusive Bind</span>. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E36\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-392C1528-D8AC-4FF7-8BD7-4467F7080E35-low.png\"></div> \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A31\"></a>With \n                     				<span class=\"MenuCascade\" id=\"GUID-8929749E-0E99-4018-8716-DB4279DA7103\">Exclusive Bind</span> turned on, each surface point (vertex) on the Pants_HighRes object is constrained\n                     or affected by the Pants_LowRes object vertices. This ensures that the Pants_HighRes\n                     object inherits the properties of the simulated nCloth pants. \n                     			 \n                  </p> \n               </li>\n               <li> Hide the Pants_LowRes object by selecting Pants_LowRes in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-57AFE3B2-43A2-4C49-95B6-517B28C46844\">Outliner</span>, and selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-F6C46E14-D7B0-43E0-B76B-84C9D6D8E81C\">Display &gt; Hide &gt; Hide Selection</span>. \n                  		  \n               </li>\n               <li> Play back the simulation. \n                  		  \n               </li>\n            </ol> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2F\"></a>When you play back the simulation, you notice the following: \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E35\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-34913F38-CD86-4EE6-8EE1-3FA55C869327-low.png\"></div> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2E\"></a><ul>\n               <li>The Pants_HighRes object appears to be simulating as if it were an nCloth object.\n                  \n                  		  \n               </li>\n               <li>The speed of the resolution is not reduced or affected by the Pants_HighRes object.\n                  \n                  		  \n               </li>\n            </ul> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2B\"></a>With the high polygon count of the Pants_HighRes object, one would expect to see the\n               simulation slow down. However, this is not the case, since the Nucleus solver is not\n               simulating any data associated with the Pants_HighRes object. All Nucleus calculations\n               involved in the simulation are still performed on the low resolution nCloth pants.\n               The behavior of the Pants_HighRes object is being influenced by a new instance of\n               the simulated nCloth pants, the Pants_LowResBase object. \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A2A\"></a>The Pants_LowResBase object is the base shape for the deformation of the Pants_HighRes\n               object, which is the wrap influence object. Like all wrap deformers, any difference\n               in position, orientation, or shape between the base shape and the wrap influence object\n               results in a deformation of the surface being influenced by the wrap deformer. \n               		\n            </p> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A29\"></a> \n            <h2><a name=\"GUID-A288B5DC-C11C-41C0-8DCB-6212DAA4DEC1\"></a>Simulating the nCloth pants on an animated character\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A28\"></a>In this section, you import geometry caches for the nRigid body and nRigid shoe objects\n               and begin simulating the nCloth pants object while the body and shoes are animated.\n               \n               		\n            </p> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A27\"></a> \n               <h3><a name=\"GUID-33ABB651-8E22-4CA8-A1FF-2D09B8984335\"></a>Lesson setup\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A26\"></a>To ensure that this section of the lesson works as described, do these steps before\n                  beginning: \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A25\"></a><ol type=\"1\" start=\"1\">\n                  <li>Hide the Pants_HighRes object by selecting \n                     				<em class=\"mild\">Pants_HighRes</em> in the \n                     				<span class=\"MenuCascade\" id=\"GUID-D80FBE92-009F-4521-9BD0-C92C2529ECB8\">Outliner</span>, and selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-86D947FE-5658-4800-9651-32E5A4CF9F11\">Display &gt; Hide &gt; Hide Selection</span>. \n                     			 \n                  </li>\n                  <li>Show the Pants_LowRes object by selecting \n                     				<em class=\"mild\">Pants_LowRes</em> in the \n                     				<span class=\"MenuCascade\" id=\"GUID-76A7811F-BAA2-43C4-A60A-71E616829F7A\">Outliner</span>, and selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-7FBE6F37-CFCF-4B85-9F40-13D540EDF139\">Display &gt; Show &gt; Show Selection</span>. \n                     			 \n                  </li>\n                  <li>If you have not already done so, set the nCloth \n                     				<span class=\"code\">nClothAdvancedTutorials</span> directory as your Maya project. \n                     			 \n                  </li>\n               </ol> \n               <div class=\"section\"><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3429\"></a> \n                  <h4><a name=\"GUID-35F7528E-C02C-415A-B779-B0F90B23FB60\"></a>Importing geometry caches\n                  </h4> \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3428\"></a>Before simulating the nCloth pants on the animated character, you need to import the\n                     geometry caches which animate the character’s body and shoes. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A22\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A21\"></a>To import the geometry caches to animate the body and shoe meshes\n                  </p>\n                  <ol type=\"1\" start=\"1\">\n                     <li>In the scene view, select the Body object. \n                        				\n                     </li>\n                     <li>From the main menu set, select \n                        				  <span class=\"MenuCascade\" id=\"GUID-527FF58F-C8AE-44B2-9A3B-2B8CCF6FABDD\">Cache &gt; Geometry Cache &gt; Import Cache</span>. \n                        				\n                     </li>\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-F5C4272E-9D4C-464C-9A81-475353D61932\">Import Cache File</span> window that appears, do the following: \n                        				  <a name=\"WS73099CC142F48755527CC80126D167FFA2-7258\"></a><ul>\n                           <li>From the \n                              						<span class=\"MenuCascade\" id=\"GUID-425D1DFF-E669-455A-8B31-5DF6D1EBD4D4\">Files of type</span> list, select \n                              						<span class=\"MenuCascade\" id=\"GUID-2B29E6FA-BD62-4379-9639-58710A6BCB30\">All Files</span>. \n                              					 \n                           </li>\n                           <li>Browse to the \n                              						<em class=\"mild\">nClothAdvancedTutorials\\data</em> folder and select \n                              						<span class=\"code\">Body_Animation.mc</span>. \n                              					 \n                           </li>\n                           <li>Click \n                              						<span class=\"MenuCascade\" id=\"GUID-366E0F33-6A4E-46A8-88F4-E06A3966666A\">Open</span>. \n                              					 \n                           </li>\n                        </ul> \n                     </li>\n                     <li>In the scene view, select the Shoes object and follow the instructions in steps 2\n                        and 3. Instead of \n                        				  <span class=\"code\">Body_Animation.mc</span>, select \n                        				  <span class=\"code\">Shoes_Animation.mc</span> from list of cache files. \n                        				\n                     </li>\n                  </ol> \n               </div> \n            </div> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A1A\"></a>You can play back the simulation to see how your nCloth pants behave when they are\n               simulated with the animated character. However, it is difficult to closely inspect\n               the simulation without being able to scrub the \n               		  <span class=\"MenuCascade\" id=\"GUID-627E664E-47AD-4247-8E86-AD4B1BF3E472\">Time Slider</span>. To make it easier to identify problems in the simulation, create a cache for the\n               nCloth pants object. For information about nCaches, see \n               		  <em class=\"mild\">nCaching \n                  		  </em> in the Maya Help. \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A19\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A18\"></a>To cache the nCloth pants simulation\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the scene view, select the nCloth pants. \n                  		  \n               </li>\n               <li>Select \n                  			 <span class=\"MenuCascade\" id=\"GUID-09BD4E44-9ED9-4BF0-A607-6526816CA416\">nCache &gt; Create New Cache &gt; nObject</span> &gt; \n                  			 <img src=\"../images/GUID-96432FB8-EBE9-4D1A-8DED-5173E032EBC0-low.png\">. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A15\"></a>The \n                     				<span class=\"MenuCascade\" id=\"GUID-76149E49-EB64-40FF-AE1B-2B8F72F9587D\">Create nCache Options \n                        				</span>window appears. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E34\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-EA9647AC-976B-4245-9214-1D05920A75E1-low.png\"></div> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-CA3DA486-7523-408E-B5A8-4FD87FC175BA\">Create nCache Options \n                     			 </span>window, do the following: \n                  			 <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A13\"></a><ul>\n                     <li>Set the \n                        				  <span class=\"MenuCascade\" id=\"GUID-1462680B-3538-4B2F-9121-B29CE6AB87AE\">Cache directory \n                           				  </span>to the folder where you want your caches saved. \n                        				\n                     </li>\n                     <li>Set the \n                        				  <span class=\"MenuCascade\" id=\"GUID-CF547B16-03BD-4E32-8023-636FD9164A16\">Cache Name \n                           				  </span>to nCloth_PantsShape. \n                        				\n                     </li>\n                     <li>Beside \n                        				  <span class=\"MenuCascade\" id=\"GUID-A3963C8A-76F4-4052-916D-D434B45B5067\">File distribution</span>, select \n                        				  <span class=\"MenuCascade\" id=\"GUID-EC20898A-804A-43AC-87D3-BF7BB0AE08CA\">One File</span>. \n                        				\n                     </li>\n                     <li>Click \n                        				  <span class=\"MenuCascade\" id=\"GUID-641B7C3C-D49B-460C-ABF9-8DF1C7997685\">Create</span>. \n                        				\n                     </li>\n                  </ul> \n               </li>\n               <li>Play back the simulation. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A0E\"></a> \n            <h2><a name=\"GUID-F2DF1143-35C9-4358-A82B-A21F1C784F2E\"></a>Identifying problem areas in the simulated nCloth\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A0D\"></a>When you play back the simulation, you notice the following problems with the nCloth\n               pants object: \n               		\n            </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A0C\"></a><ul>\n               <li>Between frames 1025 and 1035, the polygon faces around the waist and crotch area of\n                  the pants are exhibiting poor self collisions, resulting in interpenetrations. Also,\n                  the polygon faces in the front and back of the knees are poorly formed, with some\n                  polygons protruding outward making the cloth look heavy and stiff. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E33\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D3C43B4B-92D7-45C5-8A9E-DD585363FDD8-low.png\"></div> \n               </li>\n               <li>At frame 1037, the polygon faces around the ankle area are folding over each other\n                  and are becoming trapped. \n                  		  \n               </li>\n               <li>Between frames 1040 and 1045, self collision issues continue at the waist, knees,\n                  and cuff of the pants. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E32\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-C33763F8-2FAB-430A-97D3-815EB2611F88-low.png\"></div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E31\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-7D4D006F-0A4E-42E4-A196-DC14CAB46E9B-low.png\"></div> \n               </li>\n            </ul> \n            <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A07\"></a>Dolly and tumble the scene while scrubbing the \n               		  <span class=\"MenuCascade\" id=\"GUID-5356164E-7793-4962-A724-377EB2540D95\">Time Slider</span> so that you can closely observe each problem area. \n               		\n            </p> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A06\"></a> \n               <h3><a name=\"GUID-095E19D8-B7E0-4AAD-9ECA-EC9674811E8F\"></a>Editing \n                  			 <span class=\"MenuCascade\" id=\"GUID-6AFE2885-57B3-419E-8554-218698AF0008\">Substeps</span></h3> \n               <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7396\"></a>A useful first step to fixing simulation issues is to increase the number of Nucleus\n                  solver \n                  			 <span class=\"MenuCascade\" id=\"GUID-290D07D8-D9C8-4B5D-9162-EA0B998FCFF3\">Substeps</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-07B276D1-3A41-4DAB-8E15-9F205A08C4C0\">Max Collision Iterations</span>. \n                  			 <span class=\"MenuCascade\" id=\"GUID-DD653ED4-E9F6-419C-B2B0-73D7780883CD\">Substeps</span> specify the number of times per frame that the Maya Nucleus solver calculates everything\n                  involved in the simulation, from the collision detection between nCloth and passive\n                  collision objects, to the effects of \n                  			 <span class=\"MenuCascade\" id=\"GUID-069A3AD4-F9D0-45AB-A6C8-8ED8F22BA767\">Dynamic Properties</span> attributes and the dynamic constraints. Adjusting \n                  			 <span class=\"MenuCascade\" id=\"GUID-39BA31FB-2C7C-4004-9CAD-3EFD07871C11\">Substeps</span> allows you to control how the simulation time is broken up into calculation segments.\n                  Simulation quality and collision accuracy generally improve with increasing substeps\n                  values. \n                  			 <span class=\"MenuCascade\" id=\"GUID-21C35ABF-E310-4987-97B0-92C9F24BD753\">Max Collision Iterations \n                     			 </span>specify the maximum number of collision iterations per frame for this Maya Nucleus\n                  solver. A high number of \n                  			 <span class=\"MenuCascade\" id=\"GUID-DE1D66C1-AA91-4219-AFBE-749E4FBD0DF6\">Substeps</span> or \n                  			 <span class=\"MenuCascade\" id=\"GUID-9017A021-E9C7-4BAA-887F-BCC27765B77A\">Max Collision Iterations</span> may result in slower solving. \n                  		  \n               </p> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A04\"></a>Depending on the complexity of your scene, the default values of 3 \n                  			 <span class=\"MenuCascade\" id=\"GUID-B8590A46-C08C-4810-A873-92C7638131CA\">Substeps \n                     			 </span>and 4 \n                  			 <span class=\"MenuCascade\" id=\"GUID-42DFA0BA-E2D3-4F57-AC65-E8FB5F01D055\">Max Collision Iterations</span> may work well when simulating a static scene in which only gravity and wind are affecting\n                  the nCloth objects. When the nCloth begins to move and self collide, higher \n                  			 <span class=\"MenuCascade\" id=\"GUID-68F39757-A6FB-4650-B9A8-38FC2CE91201\">Substeps</span> values are required to ensure accurate collision detection, especially on fast-moving\n                  objects. Increasing \n                  			 <span class=\"MenuCascade\" id=\"GUID-B0E5058D-1AC7-43FB-AE0A-C9E9C75461A0\">Max Collision Iterations</span> becomes important when the number of nCloth collisions increases, and when dynamic\n                  constraints are added to your object. For more information, see \n                  			 <em class=\"mild\">nCloth Dynamic Properties</em> in the Maya Help. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A03\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-3A02\"></a>To edit \n                  			 <span class=\"MenuCascade\" id=\"GUID-30483BAD-AA3A-4E80-B2AE-6C5CCAE7CAA7\">Substeps \n                     			 </span>and \n                  			 <span class=\"MenuCascade\" id=\"GUID-F9072FD6-E12E-4C3F-AD96-364FC232BA77\">Max Collision Iterations</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-CB319FFF-95DF-454F-A6BF-2BB01DB91BF9\">Attribute Editor</span>, click the \n                     				<span class=\"MenuCascade\" id=\"GUID-F3A06029-E284-46E3-A36B-D711D48D4134\">nucleus1</span> tab. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-6FAAA1AE-BCB5-4B8D-8FFF-5ED26FB11C29\">Solver Attributes</span> section do the following: \n                     				<a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-39FF\"></a><ul>\n                        <li>Set \n                           					 <span class=\"MenuCascade\" id=\"GUID-4736E987-DB86-4A39-9E90-CF9F1AE77E03\">Substeps</span> to 7. \n                           				  \n                        </li>\n                        <li>Set \n                           					 <span class=\"MenuCascade\" id=\"GUID-62F82010-D8D1-4D5B-B7EE-B62294E8D700\">Max Collision Iterations</span> to 8. \n                           					 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E30\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-643E8A0C-3433-4DDD-9FA0-2BD1B9D9DFA3-low.png\"></div> \n                        </li>\n                     </ul> \n                  </li>\n                  <li>Before playing back the simulation to see the results of these new settings, you need\n                     to replace the simulation\'s previous nCache or create a new nCache. Otherwise, your\n                     changes will not appear in the simulation. \n                     				\n                     <p><a name=\"WS73099CC142F487557230B50811D7D192C64-74A8\"></a>Replacing a cache file overwrites the existing nCache with a new file. Since you will\n                        cache your simulation a number of times in the lesson, using \n                        				  <span class=\"MenuCascade\" id=\"GUID-89DC1542-E4DC-46A5-BF33-9AE915AC8923\">Replace Cache</span> is the best way to reduce the number of cache files saved to your hard disk. To replace\n                        the previous nCache, select \n                        				  <span class=\"MenuCascade\" id=\"GUID-FF8173D9-CD3F-47D1-B7CA-92C5FEACAC2B\">nCache &gt; Replace Cache &gt; nObject</span>. \n                        				\n                     </p> \n                  </li>\n                  <li>When the \n                     				<span class=\"MenuCascade\" id=\"GUID-4F443AF4-45EB-46B0-8657-9271BFD55B98\">Create Cache Warning</span> appears, click \n                     				<span class=\"MenuCascade\" id=\"GUID-A9CF92E9-08CB-4375-A0F8-0BC384D437B2\">Replace Existing</span>. \n                     			 \n                  </li>\n                  <li>Play back the simulation. \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS1A9193826455F5FF-12BA6B3A11A9C207460-39FA\"></a>When you play back the simulation, you notice that starting at frame 1030, the polygon\n                  faces in the area of the knees look more realistic. The cloth deformation is now spread\n                  over more faces, making it look more realistic. However, not all of the simulation\n                  problems were resolved. Higher \n                  			 <span class=\"MenuCascade\" id=\"GUID-D22878B3-CE76-4485-A22C-0BC47EE4408D\">Substeps</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-3BCECAF2-656C-4C0E-932E-098E3A0C0F7E\">Max Collision Iterations</span> may be required. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-98E886FD-86E2-4AA2-BBE3-5D22206E8DF3-low.png\"></div> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D15\"></a>Because increasing \n                  			 <span class=\"MenuCascade\" id=\"GUID-F0246D53-CC65-436B-85D7-C3510FBD98B7\">Substeps \n                     			 </span>and \n                  			 <span class=\"MenuCascade\" id=\"GUID-6354DBD4-138C-422D-BE99-BC86D8CB06CA\">Max Collision Iterations</span> cause the Nucleus solver to perform more calculations each simulated step, it slows\n                  down the simulation. To develop a balance between simulation quality and performance,\n                  it is useful to identify the specific areas or frames in the simulation that require\n                  higher \n                  			 <span class=\"MenuCascade\" id=\"GUID-9FAF1A8D-7139-4D29-9E50-1B8AF9963639\">Substeps</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-C392CD5A-8BDF-4083-B48B-715272E2F8CC\">Max Collision Iterations</span>. You can then animate the<span class=\"MenuCascade\" id=\"GUID-C00BFF10-9E48-40EF-B357-2ED96F20B2F6\"> Substeps</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-6AE02374-4891-459D-99F8-2EB41A437AD3\">Max Collision Iteration</span> values over the duration of the simulation by setting keyframes. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D14\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D13\"></a>To set keyframes for \n                  			 <span class=\"MenuCascade\" id=\"GUID-82D11AE3-04B5-40D0-9676-BCBBCCBC9BAC\">Substeps</span> and \n                  			 <span class=\"MenuCascade\" id=\"GUID-6D0093F6-97B8-432D-88E3-D082084D506B\">Max Collision Iterations</span></p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-143979CE-2D4A-445B-97AD-ECF838F175F2\">Time Slider</span>, go to frame 1000. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-87F0800C-B46E-468F-98BA-29C193E40C97\">Attribute Editor</span>, select the \n                     				<span class=\"MenuCascade\" id=\"GUID-74ED02BE-0DB5-45C7-8DD1-A15CA9F17F7D\">nucleus1</span> tab. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-E637D00E-EAC7-4F4A-B63B-4DC06E0D0786\">Solver Attributes \n                        				</span>section, do the following: \n                     				<a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D0F\"></a><ul>\n                        <li>Set \n                           					 <span class=\"MenuCascade\" id=\"GUID-546FA1B7-3433-43F2-AE80-2EC8DA715F43\">Substeps</span> to 5. \n                           				  \n                        </li>\n                        <li>Right-click the \n                           					 <span class=\"MenuCascade\" id=\"GUID-84565A20-CE42-4D4E-B429-55D5675BD32C\">Substeps</span> attribute field, and select \n                           					 <span class=\"MenuCascade\" id=\"GUID-E393EEA0-C889-415D-8D73-9AA97163512D\">Set Key</span> from the pop-up menu. \n                           					 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2E\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-15422F39-DBC5-4554-8AF0-E22F9EA5D9B7-low.png\"></div> \n                        </li>\n                        <li>Set<span class=\"MenuCascade\" id=\"GUID-A8512AB2-DFA6-4AEE-B34C-DD037C8E5CD0\"> Max Collision Iterations \n                              					 </span>to 6 \n                           				  \n                        </li>\n                        <li>Right-click the<span class=\"MenuCascade\" id=\"GUID-5E6770FD-FDC5-426A-9C5A-44BD7DFC00B7\"> Max Collision Iterations \n                              					 </span>attribute field, and select \n                           					 <span class=\"MenuCascade\" id=\"GUID-AB5F0A29-4ABB-4307-B377-6820295728D5\">Set Key</span> from the pop-up menu. \n                           				  \n                        </li>\n                     </ul> \n                  </li>\n                  <li>Continue setting keyframes in your simulation using values from the following table:\n                     \n                     				<a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D09\"></a><div class=\"table-ruled\">\n                        <table cellpadding=\"0\" cellspacing=\"0\" class=\"ruled\">\n                           <colgroup>\n                              <col width=\"33.33333333333333%\">\n                              <col width=\"33.33333333333333%\">\n                              <col width=\"33.33333333333333%\">\n                           </colgroup>\n                           <tr class=\"ruled-heading\">\n                              <th class=\"table-heading\">Frame \n                                 						  \n                              </th>\n                              <th class=\"table-heading\"> <span class=\"MenuCascade\" id=\"GUID-B7B8EE62-CD60-4087-96CF-A9A1690CB39A\">Substeps</span> \n                              </th>\n                              <th class=\"table-heading\"> <span class=\"MenuCascade\" id=\"GUID-668BCD73-7E0C-42CB-BD46-545281089BA7\">Max Collision Iterations</span> \n                              </th>\n                           </tr>\n                           <tr class=\"ruled-odd-row\">\n                              <td class=\"table-body\">1019 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">5 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">6 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-even-row\">\n                              <td class=\"table-body\">1020 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">7 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">8 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-odd-row\">\n                              <td class=\"table-body\">1022 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">9 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">12 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-even-row\">\n                              <td class=\"table-body\">1025 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">15 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">20 \n                                 						  \n                              </td>\n                           </tr>\n                           <tr class=\"ruled-odd-row\">\n                              <td class=\"table-body\">1060 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">9 \n                                 						  \n                              </td>\n                              <td class=\"table-body\">12 \n                                 						  \n                              </td>\n                           </tr>\n                        </table>\n                     </div> \n                  </li>\n                  <li>Cache your simulation (<span class=\"MenuCascade\" id=\"GUID-F3087307-7250-49A1-8103-565152C2347A\">nCache &gt; Replace Cache &gt; nObject</span>) and play it back. \n                     			 \n                  </li>\n               </ol> \n            </div> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D07\"></a> \n               <h3><a name=\"GUID-5724129B-F7D4-43D1-9162-8F3980405B85\"></a>Fine tuning nCloth attributes\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D06\"></a>When you play back the cache, you notice that the overall quality of the simulation\n                  has improved. However, there are still problem areas in the waist and in the crotch.\n                  For example, at frame 1030, poor self collisions in the area of the crotch are resulting\n                  in undesirable polygon deformations. To improve the quality your simulation, you can\n                  start to fine tune the \n                  			 <span class=\"MenuCascade\" id=\"GUID-44401F5A-DE8F-4D0C-B424-DC2773C3E739\">Dynamic Properties</span> attributes. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2D\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-F72CC859-9623-4F5E-A812-0A6129B6D096-low.png\"></div> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D05\"></a>When fine adjusting nCloth attributes, such as the \n                  			 <span class=\"MenuCascade\" id=\"GUID-42800A84-3966-47FF-9343-7280DCD36774\">Dynamic Properties</span> attributes, it is useful to create a duplicate of the nCloth mesh at different frames\n                  of your simulation. When you play back the simulation, you can then compare your currently\n                  simulated nCloth against the duplicate mesh and evaluate: \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D04\"></a><ul>\n                  <li>If you have correctly identified the attribute that requires adjustment. \n                     			 \n                  </li>\n                  <li>How the adjustment affects the nCloth behavior. \n                     			 \n                  </li>\n               </ul> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D01\"></a>To help solve the problems in the crotch area, you can increase \n                  			 <span class=\"MenuCascade\" id=\"GUID-85D646AD-0767-45DA-A9EF-C92171755352\">Bend Resistance \n                     			 </span>so that the edges of the polygons better retain their shape. For more information,\n                  see \n                  			 <em class=\"mild\">nCloth Dynamic Properties \n                     			 </em> in the Maya Help. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7D00\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CFF\"></a>To create a duplicate mesh and edit Bend Resistance\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-902A6C16-5DCA-4EFC-B761-0FA7CFEFEF59\">Time Slider</span>, go to frame 1030. \n                     			 \n                  </li>\n                  <li>In the scene view, select the nCloth pants and select \n                     				<span class=\"MenuCascade\" id=\"GUID-1D6C18D8-F746-4764-8CF8-CFBEA1EF9EBA\">Edit &gt; Duplicate</span>. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-60ED5737-F91B-4201-9A3B-A41736B9170A\">Outliner</span>, select \n                     				<em class=\"mild\">Pants_LowRes1 \n                        				</em>and in the scene view, move the mesh object to the right of your character. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-34C3FC5C-F5B5-45C9-B027-C7D0E674B2BC-low.png\"></div> \n                  </li>\n                  <li>In the scene view, select the original nCloth pants object , and in the \n                     				<span class=\"MenuCascade\" id=\"GUID-8462E23B-7D78-4302-8F17-FD8E36579750\">Attribute Editor</span>, click the \n                     				<span class=\"MenuCascade\" id=\"GUID-427D521A-FADD-49A6-9603-256B81FBC3F7\">nCloth_PantsShape</span> tab. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-B1B0ECFB-7DE4-44B2-B7EC-722D0FD2413B\">Dynamics Properties \n                        				</span>section, set \n                     				<span class=\"MenuCascade\" id=\"GUID-1E7AB71C-0C9A-48F8-928B-DEEF72F3D08D\">Bend Resistance</span> to 5. \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2B\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-B43576C8-9BC7-48AE-A235-7FB49B219758-low.png\"></div> \n                  </li>\n                  <li>Cache the simulation (<span class=\"MenuCascade\" id=\"GUID-3237CE8F-E4C8-4F93-87C6-ABB5D30EE7D6\">nCache &gt; Replace Cache &gt; nObject</span>) and play it back. \n                     			 \n                  </li>\n               </ol> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CF8\"></a>When you play back the simulation, you notice that the cloth is bending more realistically\n                  in the crotch area. In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-E5AAE801-C5E1-4D92-8F33-56737B140B3A\">Time Slider</span> go to frame 1030, and compare your simulated nCloth to the duplicate mesh. Dolly\n                  and tumble the scene so that you can closely observe the improved area. \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E2A\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-1AB6FF1A-BA2A-4BB3-904E-C13602143912-low.png\"></div> \n               <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E4\"></a> \n                  <h4><a name=\"GUID-F8A5C75C-6C60-49F5-9A78-972ECDBBAFE9\"></a>Editing Quality Settings and resolving interpenetrations\n                  </h4> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E3\"></a>When you play back the simulation and compare the problem areas with duplicate meshes,\n                     you notice that the problem areas between frame 1030 and 1035 still persist. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E29\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-DAE2C72C-F56B-4B34-9954-878951CDE43E-low.png\"></div> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D6B\"></a>Another way to improve simulation quality is to edit the \n                     				<span class=\"MenuCascade\" id=\"GUID-16C22CEF-BFBB-4723-9B34-1F51C2DEAA80\">Self Collision Flag</span> and \n                     				<span class=\"MenuCascade\" id=\"GUID-2EE8084B-DE14-44DB-862B-1CDE5624D756\">Quality Settings \n                        				</span>attributes, which affect the nCloth component collisions and self collisions. By default,\n                     \n                     				<span class=\"MenuCascade\" id=\"GUID-37C1BEF8-1ABD-4D78-95F5-CF59C6899027\">Self Collision Flag</span> is set to \n                     				<span class=\"MenuCascade\" id=\"GUID-26E062C2-6F3D-4090-9EC5-EB9A56998D54\">VertexFace</span>, which means that the nCloth object\'s vertices and faces collide with each other.\n                     Setting \n                     				<span class=\"MenuCascade\" id=\"GUID-CBCD712D-05FA-4C0E-AE9A-0C84E9A1E7F2\">Self Collision Flag</span> to \n                     				<span class=\"MenuCascade\" id=\"GUID-4EA99570-B98F-4D81-A2DF-85E6A75CD6C8\">Full Surface</span> sets all of the object components (vertices, edges, and faces) to participate in\n                     self collisions. \n                     			 \n                  </p> \n                  <p><a name=\"WS73099CC142F48755-789C4B1E11D24BE26D7-588C\"></a>When simulating a low resolution mesh, increasing the number of potential self collision\n                     areas of the nCloth object is important because of the mesh’s low vertex, edge, and\n                     face count. Setting \n                     				<span class=\"MenuCascade\" id=\"GUID-C276C614-548F-446B-AFC2-98F92A5621BB\">Self Collision Flag</span> to \n                     				<span class=\"MenuCascade\" id=\"GUID-49741BB7-1C5B-4857-BEAC-8D8D9D139CF6\">Full Surface</span> on high resolution nCloth meshes increases simulation time. This is less of an issue\n                     with low resolution meshes, which makes this alternative much more appealing for iterative\n                     simulation tests. For more information, see \n                     				<em class=\"mild\">nCloth Collision attributes</em> in the Maya Help. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D6A\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D69\"></a>To edit the \n                     				<span class=\"MenuCascade\" id=\"GUID-1CD37885-9F17-4187-A91F-D8BFE004586F\">Self Collision Flag</span> attribute\n                  </p>\n                  <ol type=\"1\" start=\"1\">\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-AA82963E-9C2F-46D2-905A-AC02A6197353\">Time Slider</span>, go to frame 1033. \n                        				\n                     </li>\n                     <li>In the scene view, select the nCloth pants and select \n                        				  <span class=\"MenuCascade\" id=\"GUID-366C7E2E-8258-4622-BBD9-4295D7D17F51\">Edit &gt; Duplicate</span>. \n                        				\n                     </li>\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-D9A6A311-2E7E-420F-87A8-C84F9FC677EE\">Outliner</span>, select<em class=\"mild\"> Pants_LowRes2</em> and in the scene view, move the mesh object to the left of your character. \n                        				  <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E28\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-2461E1DB-2EB2-4152-9363-6E5BF92D7563-low.png\"></div> \n                     </li>\n                     <li>In scene view, select the original nCloth pants object, and in the \n                        				  <span class=\"MenuCascade\" id=\"GUID-AF6B0A8A-8534-4265-9A9E-710E389DAEC2\">Attribute Editor</span>, click the \n                        				  <span class=\"MenuCascade\" id=\"GUID-143DB696-2FA5-4FA6-819B-73730193982B\">nCloth_PantsShape</span> tab. \n                        				\n                     </li>\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-1F0C4365-F299-4D23-9209-7464BF6A1945\">Collisions</span> section, set \n                        				  <span class=\"MenuCascade\" id=\"GUID-33526C0B-198F-4305-9981-F8E7E89C1CF1\">Self Collision Flag</span> to \n                        				  <span class=\"MenuCascade\" id=\"GUID-3ECAFF09-610A-4AE6-AB9F-149746B1EED9\">Full Surface</span>. \n                        				  <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E27\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-1C6106AB-DD9D-4F64-9A8A-BAE75CC01D2E-low.png\"></div> \n                     </li>\n                  </ol> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D62\"></a>Setting the \n                     				<span class=\"MenuCascade\" id=\"GUID-0012101A-F314-4909-97A0-7AE952481341\">Self Collision Flag</span> attribute to \n                     				<span class=\"MenuCascade\">Full Surface</span> improves self-collisions, but may create some trapped self colliding vertices. You\n                     can edit the \n                     				<span class=\"MenuCascade\" id=\"GUID-1054860C-8156-4E78-94CC-E215C66AD67D\">Quality Settings</span> to resolve this issue and other remaining interpenetrations between the nCloth pants\n                     object and the nRigid shoes. You can also increase \n                     				<span class=\"MenuCascade\" id=\"GUID-BCF9EE49-7A55-4C07-8808-197695AD27A0\">Thickness</span> or create a \n                     				<span class=\"MenuCascade\" id=\"GUID-B6036190-E2C3-41E5-9451-16D722C058A9\">Thickness Map</span> to improve collision detection. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E1\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62E0\"></a>To edit the \n                     				<span class=\"MenuCascade\" id=\"GUID-F2445603-FD02-4C97-8D9F-B2CD07FDDF26\">Quality Settings</span></p>\n                  <ol type=\"1\" start=\"1\">\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-1D1A640A-E917-4B90-90D6-0B08CD6FB921\">Attribute Editor</span>, select the \n                        				  <span class=\"MenuCascade\" id=\"GUID-1C6FD334-7EA7-4CFF-8D4E-51A340F0E0FC\">nCloth_PantsShape</span> tab. \n                        				\n                     </li>\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-CF73B2EE-C44E-435B-813F-4665101ACF65\">Quality Settings</span> section, do the following: \n                        				  <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62DD\"></a><ul>\n                           <li>Make sure \n                              						<span class=\"MenuCascade\" id=\"GUID-D8F164C7-BFE2-462B-A4A7-0B3AFF019284\">Max Iterations</span> is set to 10000. \n                              					 \n                           </li>\n                           <li>Turn on \n                              						<span class=\"MenuCascade\" id=\"GUID-DC8E07AA-BE59-4632-8A72-AA3BC14185BB\">Trapped Check</span>. \n                              					 \n                           </li>\n                           <li>Turn on \n                              						<span class=\"MenuCascade\" id=\"GUID-784F4BA0-9597-476C-BC3A-5C2F95721407\">Self Trapped Check</span>. \n                              						<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E26\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-D8736D0F-D942-48EF-A1C7-96D3611A1841-low.png\"></div> \n                           </li>\n                        </ul> \n                     </li>\n                     <li>Cache the simulation \n                        				  <span class=\"MenuCascade\" id=\"GUID-61FE00C1-82BD-4732-9E1F-1F856D3636A4\">nCache &gt; Replace Cache &gt; nObject</span> and then play it back. \n                        				\n                     </li>\n                  </ol> \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D61\"></a>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-208FCDB0-7E8E-4AC0-BEE7-BF3797AD8908\">Time Slider</span>, go to frame 1033, and compare your simulated nCloth to the duplicate mesh. Dolly\n                     and tumble the scene so that you can closely observe the problem area. When you are\n                     satisfied with your observations, delete the \n                     				<em class=\"mild\">Pants_LowRes1</em> and \n                     				<em class=\"mild\">Pants_LowRes2</em> duplicate meshes. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E25\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-E1B1666D-23D3-45FD-9F95-C9EAD4792362-low.png\"></div> \n               </div> \n            </div> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD3\"></a> \n               <h3><a name=\"GUID-EE32C491-DB5D-4926-9DF7-5F4FFDD9380A\"></a>Comparing the wrapped nCloth simulation with the simulated high resolution mesh\n               </h3> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD2\"></a>To complete the attribute adjustments of the nCloth pants object, you compare the\n                  wrapped nCloth simulation to the reference character object (the original simulated\n                  high resolution mesh). \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD1\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CD0\"></a>To compare the low and high resolution nCloth meshes\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>Hide the Pants_LowRes object, selecting it in the \n                     				<span class=\"MenuCascade\" id=\"GUID-F17301FD-230A-43A2-855B-B6A407349711\">Outliner</span>, and then selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-709715CA-7AF8-40C7-A642-E220AC663E40\">Display &gt; Hide &gt; Hide Selection</span>. \n                     			 \n                  </li>\n                  <li>Show the Pants_HighRes object by selecting it in the \n                     				<span class=\"MenuCascade\" id=\"GUID-27DD03EC-E080-45A9-A295-A6F16B5F0539\">Outliner</span>, and then selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-E6C50E83-8BD4-4E48-98A0-29E992C9AFA2\">Display &gt; Show &gt; Show Selection</span>. \n                     			 \n                  </li>\n                  <li>Using the \n                     				<span class=\"MenuCascade\" id=\"GUID-6528DDFE-1553-40A9-8417-532115C90674\">Display Layer</span> editor (<span class=\"MenuCascade\" id=\"GUID-66FC8CF8-C452-42A2-94D8-5D408F410621\">Channel Box/ Layer Editor&gt; Display Tab &gt; Layers &gt; Set Selected Layers \n                        				</span>), turn on Visible to display the Reference_Character object in the scene view. \n                     			 \n                  </li>\n                  <li>Hide the Reference_Shirt object, selecting it in the \n                     				<span class=\"MenuCascade\" id=\"GUID-F6C40F9F-2D39-4602-959E-6339FFCDA1B9\">Outliner</span>, and then selecting \n                     				<span class=\"MenuCascade\" id=\"GUID-57614FCA-C129-4C96-A1AD-E16889D2EA37\">Display &gt; Hide &gt; Hide Selection</span>. \n                     			 \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-0BB3BEBF-5830-4C88-BFFC-10115CE806C0\">Shading</span> menu, turn off \n                     				<span class=\"MenuCascade\" id=\"GUID-5E5E5ACB-A5E3-4242-ADF2-FCF346DDD11F\">Wireframe on Shaded</span>. \n                     			 \n                  </li>\n                  <li>Scrub through the \n                     				<span class=\"MenuCascade\" id=\"GUID-2E57BF9D-4C21-4078-8073-5E3C833F9628\">Time Slider</span> to compare how the nCloth meshes behave in the animation. Dolly and tumble the scene\n                     so that you can closely observe the problem area. \n                     				\n                     <div><a name=\"WS73099CC142F487557230B50811D7D192C64-74A7\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> \n                           <p><a name=\"GUID-600BC39F-3DA4-4A3E-8F25-DF1CEAA65D2F\"></a>If the Reference_Character is not animated in the scene view when you play back or\n                              scrub the simulation, you may need to reconnect the reference character’s caches to\n                              their respective objects. See \n                              					 <span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3426\">Reconnecting objects to existing caches</a></span>. \n                              				  \n                           </p> \n                        </div>\n                     </div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E24\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-3F9DF6A2-2FF3-4FC3-80CE-23BBF55E0E3A-low.png\"></div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E23\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-69B59E06-FB63-4DEC-91A0-623CC01E4612-low.png\"></div> \n                  </li>\n               </ol> \n               <div class=\"section\"><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3426\"></a> \n                  <h4><a name=\"GUID-B83DA460-103F-4290-8DF3-9B995F1485D2\"></a>Reconnecting objects to existing caches\n                  </h4> <a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3425\"></a><ol type=\"1\" start=\"1\">\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-BBB424C7-87AD-440C-9040-268CCD7517AB\">Outliner</span>, select the object whose cache you want to reconnect. \n                        				\n                     </li>\n                     <li>In \n                        				  <span class=\"MenuCascade\" id=\"GUID-CC2BE82C-3E16-4F8B-82B8-FE13791813B9\">Attribute Editor</span>, select the object’s cache node. \n                        				  \n                        <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3422\"></a>For example, if you are reconnecting the cache for the character’s body, select the\n                           \n                           					 <span class=\"MenuCascade\" id=\"GUID-089745B6-1CFF-4F93-A40E-0571D9F9398A\">Body_AnimationCache1</span> tab. \n                           				  \n                        </p> \n                     </li>\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-B166E613-F12C-4E96-9648-551A4FFDA63D\">Cache File</span> section, make sure that \n                        				  <span class=\"MenuCascade\" id=\"GUID-88048C18-C4E1-45AF-96FA-385152AEB334\">Base Directory</span> is set to the \n                        				  <span class=\"code\">nClothAdvancedTutorials</span> project \n                        				  <span class=\"code\">data</span> folder by clicking the \n                        				  <img src=\"../images/GUID-A194DBA7-DE15-428A-BA1C-441AAF942080-low.png\">icon. \n                        				\n                     </li>\n                     <li>In the \n                        				  <span class=\"MenuCascade\" id=\"GUID-C6697C81-0D5D-4717-805D-36F0E3FBB69F\">Assign Cache Directory</span> window, click \n                        				  <span class=\"MenuCascade\" id=\"GUID-6410AD22-F0E2-4643-BFEE-D74FC26036B7\">Open</span>. \n                        				\n                     </li>\n                  </ol> \n               </div> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CCB\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CCA\"></a>Observations\n               </p> \n               <p><a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC9\"></a>When you play back or scrub the simulation, you notice the following: \n                  		  \n               </p> <a name=\"WS1A9193826455F5FF73C538A911AF8B6901A-7CC8\"></a><ul>\n                  <li>Overall, the wrapped nCloth pants and reference character objects behave in the same\n                     way. \n                     			 \n                  </li>\n                  <li>Between frames 1040 and 1047, the pant legs on nCloth pants object are falling a little\n                     faster than the pant legs on the reference character object. \n                     			 \n                  </li>\n               </ul> \n               <div><a name=\"WS1A9193826455F5FF211A40BE11DCC57291C-72CA\"></a><div class=\"note-tip\"><span class=\"label label-target-language\">TIP:</span> To force the pant legs of the nCloth pants to simulate in the same way as the pant\n                     legs on the reference character object, you can adjust the \n                     			 <span class=\"MenuCascade\" id=\"GUID-5B6DB957-6FAA-408C-8946-2C7072B96516\">Friction</span> attribute. \n                     		  \n                  </div>\n               </div> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";